/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.ucode;

import com.ibm.hsc.auiml.databeans.ucode.IOSurveyResultsData;
import com.ibm.hsc.auiml.databeans.ucode.RepositoryItem;
import com.ibm.hsc.auiml.databeans.ucode.ResourceItem;
import com.ibm.hsc.auiml.databeans.ucode.SurveyFileResult;
import com.ibm.hsc.auiml.databeans.ucode.UcodeSurveyException;
import com.ibm.hsc.auiml.databeans.ucode.UcodeSurveyProperties;
import com.ibm.hsc.auiml.databeans.ucode.XMLFileResult;
import com.ibm.hsc.common.util.CECInfo;
import com.ibm.hsc.common.util.CIMUtils;
import com.ibm.hsc.common.util.Crypt;
import com.ibm.hsc.common.util.Trace;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class UcodeSurveyDownload {
    private static final String TRACE_MASKD = "JUCODESD";
    private static final String TRACE_MASKF = "JUCODESF";
    private static final String TRACE_MASKT = "JUCODEST";
    private static final short ERRID_0001 = 1;
    private static final short ERRID_0002 = 2;
    private static final short ERRID_0003 = 3;
    private final String DOWNLOAD_FTP_SCRIPT = "/var/adm/invscout/getRemoteFirmwareFile";
    private final String DOWNLOAD_CDROM_SCRIPT = "/var/adm/invscout/getFileFromCDROM";
    private final String FRUCODE_CMD = "/opt/hsc/bin/frucode";
    private final String HMC_FILE = "/opt/hsc/bin/hsc";
    private final String HSC_DO_CMD_EXECUTABLE = "/opt/hsc/bin/hscdc";
    private final String SERVICE_TARGET_DIRECTORY = "/var/adm/invscout/microcode/";
    private final String DEFAULT_TARGET_DIRECTORY = "/var/adm/invscout/";
    private final String SURVEY_TARGET_FILE_SUFFIX = ".mup";
    private final String LICENSE_TARGET_FILE_SUFFIX = ".mic";
    private final String RPM_FILENAME = "*.rpm";
    private final String UCODE_PROPERTIES_FILE = "/var/adm/invscout/ucodesurvey.properties";
    private final String CHMOD_COMMAND = "chmod 666 ";
    private final String SUCCESSFUL_COPY = "Successful copy of Frame corrective service data file";
    private boolean _fromCDROM = false;
    private boolean _fromFtpSite = false;
    private boolean _fromHttpSite = false;
    IOSurveyResultsData surveyData;

    public UcodeSurveyDownload(IOSurveyResultsData iOSurveyResultsData) {
        this.surveyData = iOSurveyResultsData;
    }

    public IOSurveyResultsData getIOSurveyData() {
        return this.surveyData;
    }

    private String parsePartitionID(String string) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.parsePartitionID(" + string + ")");
        }
        int n = Integer.parseInt(string);
        String string2 = Integer.toString(n);
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.parsePartitionID(" + string2 + ")");
        }
        return string2;
    }

    private StringBuffer parsePassword(String string) {
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer("");
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string2);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c == '\\') {
                stringBuffer.append(c);
                stringBuffer.append(c);
                stringBuffer.append(c);
            } else if (c == '`' || c == '$' || c == '\"' || c == '\'' || c == ';' || c == '|' || c == '<' || c == '>' || c == '(' || c == ')' || c == '&') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            c = stringCharacterIterator.next();
        }
        return stringBuffer;
    }

    private String processErrorCode(int n) {
        String string;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.processErrorCode()");
        }
        switch (n) {
            case 2: {
                string = "0020";
                break;
            }
            case 3: {
                string = "0021";
                break;
            }
            case 4: {
                string = "0022";
                break;
            }
            case 8: {
                string = "0023";
                break;
            }
            case 9: {
                string = "0052";
                break;
            }
            default: {
                string = "0024";
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.processErrorCode()");
        }
        return string;
    }

    public void getFileFromCDROM(String string, String string2) throws UcodeSurveyException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.getFileFromCDROM()");
        }
        EExecResult eExecResult = null;
        String string3 = "";
        this._fromCDROM = true;
        this._fromFtpSite = false;
        this._fromHttpSite = false;
        string3 = string.startsWith("/") ? string.substring(1) : string;
        String string4 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("/var/adm/invscout/getFileFromCDROM") + " " + string3 + " " + string2;
        if (Trace.LEVEL >= 3) {
            Trace.trace(TRACE_MASKD, "About to issue command: </var/adm/invscout/getFileFromCDROM " + string3 + " " + string2 + ">");
        }
        try {
            eExecResult = EExec.Exec((String)string4);
            if (eExecResult.rc != 0) {
                if (Trace.LEVEL >= 2) {
                    Trace.trace(TRACE_MASKF, "Command " + string4 + " failed with a rc of " + eExecResult.rc + ".");
                }
                String string5 = this.processErrorCode(eExecResult.rc);
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Throwing exception " + string5);
                }
                throw new UcodeSurveyException(string5);
            }
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "File, " + string3 + " successfully copied from CDROM");
            }
            eExecResult = EExec.Exec((String)("chmod 666 " + string2 + string3));
            if (eExecResult.rc != 0) {
                // empty if block
            }
            if (Trace.LEVEL >= 2) {
                Trace.trace(TRACE_MASKF, "Command chmod 666 " + string2 + string3 + " completed with a rc of " + eExecResult.rc + ".");
            }
        }
        catch (UcodeSurveyException ucodeSurveyException) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Caught inner UcodeSurveyException " + ucodeSurveyException.getKey());
            }
            throw ucodeSurveyException;
        }
        catch (Exception exception) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Caught generic exception " + exception);
            }
            throw new UcodeSurveyException("0025");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.getFileFromCDROM()");
        }
    }

    public void getFileFromFtpSite(String string, String string2, String string3, String string4, String string5) throws UcodeSurveyException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.getFileFromFtpSite(" + string + "," + string2 + "," + string3 + "," + string4 + "," + string5 + ")");
        }
        EExecResult eExecResult = null;
        try {
            StringBuffer stringBuffer = this.parsePassword(string);
            StringBuffer stringBuffer2 = this.parsePassword(string2);
            StringBuffer stringBuffer3 = this.parsePassword(string3);
            StringBuffer stringBuffer4 = this.parsePassword(string4);
            this._fromCDROM = false;
            this._fromFtpSite = true;
            this._fromHttpSite = false;
            String string6 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("/var/adm/invscout/getRemoteFirmwareFile") + " " + stringBuffer + " " + stringBuffer2 + " " + stringBuffer3 + " " + stringBuffer4 + " " + string5;
            String string7 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("/var/adm/invscout/getRemoteFirmwareFile") + " " + stringBuffer + " " + stringBuffer2 + " " + stringBuffer3 + " ******** " + string5;
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "About to issue command: </var/adm/invscout/getRemoteFirmwareFile " + stringBuffer + " " + stringBuffer2 + " " + stringBuffer3 + " ******** " + string5 + ">");
            }
            eExecResult = EExec.Exec((String)string6);
            if (eExecResult.rc != 0) {
                if (Trace.LEVEL >= 2) {
                    Trace.trace(TRACE_MASKF, "Command " + string7 + " failed with a rc of " + eExecResult.rc + ".");
                }
                String string8 = this.processErrorCode(eExecResult.rc);
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Throwing exception " + string8);
                }
                throw new UcodeSurveyException(string8);
            }
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "File, " + string2 + " successfully ftp'd");
            }
            eExecResult = EExec.Exec((String)("chmod 666 " + string5 + string2));
            if (eExecResult.rc != 0) {
                // empty if block
            }
            if (Trace.LEVEL >= 2) {
                Trace.trace(TRACE_MASKF, "Command chmod 666 " + string5 + string2 + " completed with a rc of " + eExecResult.rc + ".");
            }
        }
        catch (UcodeSurveyException ucodeSurveyException) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Caught inner UcodeSurveyException " + ucodeSurveyException.getKey());
            }
            throw ucodeSurveyException;
        }
        catch (Exception exception) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Caught generic exception " + exception);
            }
            throw new UcodeSurveyException("0025");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.getFileFromFtpSite()");
        }
    }

    public void getFileFromHttpSite(String string, String string2) throws UcodeSurveyException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.getFileFromHttpSite(" + string + " " + string2 + ")");
        }
        EExecResult eExecResult = null;
        try {
            HttpURLConnection httpURLConnection;
            this._fromCDROM = false;
            this._fromFtpSite = false;
            this._fromHttpSite = true;
            String string3 = UcodeSurveyProperties.getProperty("weburl");
            String string4 = string3 + string;
            String string5 = "";
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "-- urlToFetch is " + string4);
            }
            try {
                URL uRL = new URL(string4);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setAllowUserInteraction(false);
                httpURLConnection.setRequestProperty("Referer", string4);
                httpURLConnection.connect();
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{string4};
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Error reading website: " + string3 + ":" + exception);
                }
                throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0055", objectArray));
            }
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "-- HttpURLConnection.connect() request successful.");
            }
            if (httpURLConnection.getResponseCode() != 200) {
                Object[] objectArray = new Object[]{httpURLConnection.getResponseMessage()};
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Error reading  " + string4 + ": " + objectArray[0]);
                }
                throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0039", objectArray));
            }
            if (httpURLConnection.getContentType().equals("text/html")) {
                Object[] objectArray = new Object[]{httpURLConnection.getContentType()};
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Error reading  " + string4 + ": " + objectArray[0]);
                }
                throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0040", objectArray));
            }
            try {
                int n;
                int n2 = string4.lastIndexOf("/");
                String string6 = string5 = n2 != -1 ? string4.substring(n2 + 1) : string4;
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Downloading File " + string5);
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2 + string5));
                byte[] byArray = new byte[4096];
                while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                }
                ((OutputStream)bufferedOutputStream).close();
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "File, " + string + " successfully downloaded from web site to " + string2);
                }
                eExecResult = EExec.Exec((String)("chmod 666 " + string2 + string));
                if (eExecResult.rc != 0) {
                    // empty if block
                }
                if (Trace.LEVEL >= 2) {
                    Trace.trace(TRACE_MASKF, "Command chmod 666 " + string2 + string + " completed with a rc of " + eExecResult.rc + ".");
                }
            }
            catch (Exception exception) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "-- Exception " + exception + " reading file " + string5);
                }
                Object[] objectArray = new Object[]{exception.toString()};
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Error reading  " + string5 + ": " + objectArray[0]);
                }
                throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0039", objectArray));
            }
        }
        catch (UcodeSurveyException ucodeSurveyException) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Caught inner UcodeSurveyException " + ucodeSurveyException.getKey());
            }
            throw ucodeSurveyException;
        }
        catch (Exception exception) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Caught generic exception " + exception);
            }
            throw new UcodeSurveyException("0025");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.getFileFromHttpSite()");
        }
    }

    public boolean httpFileExist(String string) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.httpFileExist()");
        }
        Object var2_2 = null;
        boolean bl = false;
        String string2 = UcodeSurveyProperties.getProperty("weburl");
        String string3 = string2 + string;
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "-- urlToFetch is " + string3);
        }
        try {
            URL uRL = new URL(string3);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("HEAD");
            httpURLConnection.connect();
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "-- HttpURLConnection.connect() request successful for: " + string3);
                Trace.trace(TRACE_MASKF, "-- Response code is: " + httpURLConnection.getResponseCode());
                Trace.trace(TRACE_MASKF, "-- Content Type is: " + httpURLConnection.getContentType());
            }
            int n = 0;
            String string4 = httpURLConnection.getHeaderField(n);
            String string5 = httpURLConnection.getHeaderField(string4);
            Trace.trace(TRACE_MASKF, "-- HeaderKey=" + string4);
            if (httpURLConnection.getResponseCode() != 200) {
                Object[] objectArray = new Object[]{httpURLConnection.getContentType()};
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Error finding " + string3 + ": " + objectArray[0]);
                }
                bl = false;
            } else {
                bl = true;
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{string3};
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "-- HttpURLConnection.connect() ERROR " + exception + " looking for: " + string3);
            }
            bl = false;
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.httpFileExist()");
        }
        return bl;
    }

    public XMLFileResult readFixpackXMLFile(String string) throws UcodeSurveyException {
        BufferedReader bufferedReader;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.readFixpackXMLFile()");
            Trace.trace(TRACE_MASKT, "Checking for file " + string);
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
        }
        catch (IOException iOException) {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "Error processing/finding file" + string);
                Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.readFixpackXMLFile()");
            }
            Object[] objectArray = new Object[]{string, iOException.toString()};
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Throwing file io exception " + objectArray[0]);
            }
            throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0004", objectArray));
        }
        XMLFileResult xMLFileResult = new XMLFileResult();
        int n = 0;
        if (bufferedReader != null) {
            try {
                xMLFileResult = new XMLFileResult();
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    if (string2.trim().length() > 0) {
                        xMLFileResult.saveLine(string2);
                        ++n;
                    }
                    string2 = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                try {
                    if (1 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "IO Exception reading xml file: " + iOException);
                    }
                    bufferedReader.close();
                }
                catch (IOException iOException2) {
                    if (1 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.readFixpackXMLFile()");
                    }
                    Object[] objectArray = new Object[]{string};
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "Throwing file close exception " + objectArray[0]);
                    }
                    throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0005", objectArray));
                }
            }
        } else {
            try {
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Error: XML File was empty");
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.readFixpackXMLFile()");
                }
                Object[] objectArray = new Object[]{string};
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Throwing file close exception " + objectArray[0]);
                }
                throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0005", objectArray));
            }
        }
        if (n > 0) {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.readFixpackXMLFile()");
            }
            return xMLFileResult;
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.readFixpackXMLFile()");
        }
        Object[] objectArray = new Object[]{string, "File is empty"};
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "Throwing file io exception " + objectArray[0]);
        }
        throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0004", objectArray));
    }

    public SurveyFileResult doUcodeSurvey(String string, String string2) throws UcodeSurveyException {
        int n;
        SurveyFileResult surveyFileResult = null;
        String string3 = string;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.doUcodeSurvey()");
        }
        if ((n = string3.indexOf("_")) == -1) {
            n = string3.indexOf("*");
        }
        if (n != -1) {
            String string4 = string3.substring(0, n);
            String string5 = string3.substring(n + 1, string3.length());
            String string6 = " ";
            String string7 = "";
            int n2 = 0;
            String string8 = " ";
            String string9 = " ";
            EExecResult eExecResult = null;
            String string10 = " ";
            try {
                String string11 = string3.equals("0000-000_0000000") ? "frame" : string4 + "_" + string5;
                string7 = string2 + string11 + ".mup";
                string6 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("rm") + " -f " + string7;
                eExecResult = EExec.Exec((String)string6);
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Remove file command <" + string6 + ">, rc = " + eExecResult.rc);
                }
                string6 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("rm") + " -f " + string2 + "*.rpm";
                eExecResult = EExec.Exec((String)string6);
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Remove rpms command <" + string6 + ">, rc = " + eExecResult.rc);
                }
                string6 = string3.equals("0000-000_0000000") ? "/usr/sbin/invscout -mcfs" : "/usr/sbin/invscout -m " + string4 + " -s " + string5;
                eExecResult = EExec.Exec((String)string6);
                if (eExecResult.rc > 7) {
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "Inventory Scout command <" + string6 + "> failed, rc = " + eExecResult.rc);
                        Trace.trace(TRACE_MASKF, "stderr is <" + eExecResult.stderr + ">");
                    }
                    string10 = eExecResult.stderr;
                    Object[] objectArray = new Object[3];
                    objectArray[1] = Integer.toString(eExecResult.rc);
                    objectArray[0] = string6;
                    objectArray[2] = string10;
                    throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0041", objectArray));
                }
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Inventory Scout command <" + string6 + "> was successful with rc=" + eExecResult.rc);
                }
                n2 = eExecResult.rc;
                eExecResult.rc = 0;
                string8 = eExecResult.stderr;
                string9 = string6;
                surveyFileResult = this.getDataFile(string7);
            }
            catch (UcodeSurveyException ucodeSurveyException) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Caught inner UcodeSurveyException " + ucodeSurveyException.getKey() + " args:" + ucodeSurveyException.getArgs());
                }
                throw ucodeSurveyException;
            }
            catch (Exception exception) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Exception caught during survey processing, " + exception);
                }
                String string12 = Integer.toString(eExecResult.rc);
                Object[] objectArray = new Object[3];
                try {
                    objectArray[1] = Integer.toString(eExecResult.rc);
                }
                catch (Exception exception2) {
                    objectArray[1] = Integer.toString(127);
                }
                objectArray[0] = "/usr/sbin/invscout -m";
                objectArray[2] = string10;
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Throwing invscout exception " + objectArray[0]);
                }
                throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0041", objectArray));
            }
        }
        Object[] objectArray = new Object[]{string3};
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "Throwing exception for invalid MTMS");
        }
        throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0045", objectArray));
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.doUcodeSurvey()");
        }
        return surveyFileResult;
    }

    public SurveyFileResult getLicenseFile() throws UcodeSurveyException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.getLicenseFile()");
        }
        String string = "/var/adm/invscout/microcode/" + UcodeSurveyProperties.getProperty("licensename");
        SurveyFileResult surveyFileResult = this.getDataFile(string);
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.getLicenseFile()");
        }
        return surveyFileResult;
    }

    public SurveyFileResult getDataFile(String string) throws UcodeSurveyException {
        BufferedReader bufferedReader;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.getDataFile()");
            Trace.trace(TRACE_MASKT, "Checking for file " + string);
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
        }
        catch (IOException iOException) {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "Error processing/finding file" + string);
                Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.getDataFile()");
            }
            Object[] objectArray = new Object[]{string, iOException.toString()};
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Throwing file io exception " + objectArray[0]);
            }
            throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0004", objectArray));
        }
        SurveyFileResult surveyFileResult = new SurveyFileResult();
        int n = 0;
        if (bufferedReader != null) {
            try {
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    if (string2.trim().length() > 0) {
                        surveyFileResult.saveRecord(string2);
                        ++n;
                    }
                    string2 = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                try {
                    if (1 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "IO Exception reading survey file: " + iOException);
                    }
                    bufferedReader.close();
                }
                catch (IOException iOException2) {
                    if (1 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.getDataFile()");
                    }
                    Object[] objectArray = new Object[]{string};
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "Throwing file close exception " + objectArray[0]);
                    }
                    throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0005", objectArray));
                }
            }
        } else {
            try {
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Error: Survey File was empty");
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.getDataFile()");
                }
                Object[] objectArray = new Object[]{string};
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Throwing file close exception " + objectArray[0]);
                }
                throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0005", objectArray));
            }
        }
        if (n > 0) {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.getDataFile()");
            }
            return surveyFileResult;
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.getDataFile()");
        }
        Object[] objectArray = new Object[]{string, "File is empty"};
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "Throwing file io exception " + objectArray[0]);
        }
        throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0004", objectArray));
    }

    public synchronized void RPMPackageInstall(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws UcodeSurveyException {
        block28: {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.RPMPackageInstall(" + string + "," + string2 + "," + string3 + "," + string4 + "," + string5 + "," + string6 + string7 + "," + string8 + ")");
            }
            String string9 = string;
            try {
                int n;
                File file = new File(string2);
                if (!file.exists() || !file.isFile()) {
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "Downloading/Copying file " + string2);
                    }
                    if (this.getIOSurveyData().getReposLevel().getReposType() == 1) {
                        this.getFileFromCDROM(string8 + string2, string7);
                    } else if (this.getIOSurveyData().getReposLevel().getReposType() == 4) {
                        this.getFileFromFtpSite(string4, string8 + string2, string5, string6, string7);
                    } else if (this.getIOSurveyData().getReposLevel().getReposType() == 0) {
                        this.getFileFromHttpSite(string8 + string2, string7);
                    } else if (1 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKT, "ERROR - No valid repository location found!");
                    }
                }
                if ((n = string9.indexOf("_")) == -1) {
                    n = string9.indexOf("*");
                }
                EExecResult eExecResult = null;
                if (n != -1) {
                    String string10 = string9.substring(0, n);
                    String string11 = string9.substring(n + 1, string9.length());
                    String string12 = null;
                    string12 = string3.equals("BPA") ? "/opt/hsc/bin/hscdc " + Crypt.encrypt("/bin/rpm") + " -i --force " + string7 + string2 : "/usr/sbin/invscout -RPM " + string2 + " -o \"'-i --force'\" -m " + string10 + " -s " + string11 + " -p " + this.parsePartitionID(string3);
                    String string13 = " ";
                    try {
                        eExecResult = EExec.Exec((String)string12);
                        if (eExecResult.rc != 0) {
                            if (2 <= Trace.LEVEL) {
                                Trace.trace(TRACE_MASKF, "Command <" + string12 + "> returned a non-zero return code. rc = " + eExecResult.rc);
                                Trace.trace(TRACE_MASKF, "stderr is <" + eExecResult.stderr + ">");
                            }
                            string13 = eExecResult.stderr;
                        } else if (2 <= Trace.LEVEL) {
                            Trace.trace(TRACE_MASKF, "Inventory Scout command '" + string12 + "' succeeded");
                        }
                    }
                    catch (Throwable throwable) {
                        eExecResult.rc = 127;
                    }
                    if (eExecResult.rc != 0) {
                        Object[] objectArray = new Object[3];
                        objectArray[1] = Integer.toString(eExecResult.rc);
                        objectArray[0] = string12;
                        objectArray[2] = string13;
                        if (2 <= Trace.LEVEL) {
                            Trace.trace(TRACE_MASKF, "Throwing invscout exception " + objectArray[0]);
                        }
                        throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0041", objectArray));
                    }
                    break block28;
                }
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "-- input parameter error, malformed MTMS is: <" + string9 + ">");
                }
                Object[] objectArray = new Object[]{string9};
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Throwing mtms exception " + objectArray[0]);
                }
                throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0045", objectArray));
            }
            catch (UcodeSurveyException ucodeSurveyException) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Caught inner UcodeSurveyException " + ucodeSurveyException.getKey());
                }
                throw ucodeSurveyException;
            }
            catch (Exception exception) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "-- Exception caught is: " + exception);
                }
                throw new UcodeSurveyException("0025");
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.RPMPackageInstall()");
        }
    }

    public void RPMPackageDownload(String string, RepositoryItem repositoryItem, String string2) throws UcodeSurveyException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.RPMPackageDownload()");
        }
        RepositoryItem repositoryItem2 = repositoryItem;
        String string3 = string;
        String string4 = repositoryItem2.getLocation();
        String string5 = repositoryItem2.getFTPUSER();
        String string6 = repositoryItem2.getFTPPW();
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "Downloading file " + string3 + " from " + string4 + " to " + string2);
        }
        try {
            File file = new File(string3);
            if (!file.exists() || !file.isFile()) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Downloading/Copying file " + string3);
                }
                if (repositoryItem2.getReposType() == 1) {
                    this.getFileFromCDROM(string3, string2);
                } else if (repositoryItem2.getReposType() == 4) {
                    this.getFileFromFtpSite(string4, string3, string5, string6, string2);
                } else if (repositoryItem2.getReposType() == 0) {
                    this.getFileFromHttpSite(string3, string2);
                } else if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKT, "ERROR - No valid repository location found!");
                }
            }
        }
        catch (UcodeSurveyException ucodeSurveyException) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Caught inner UcodeSurveyException " + ucodeSurveyException.getKey());
            }
            throw ucodeSurveyException;
        }
        catch (Exception exception) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "-- Exception caught is: " + exception);
            }
            throw new UcodeSurveyException("0025");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.RPMPackageDownload()");
        }
    }

    public void RPMPackageErase(String string, String string2, String string3) throws UcodeSurveyException {
        block21: {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.RPMPackageErase()");
            }
            String string4 = string;
            try {
                int n = string4.indexOf("_");
                if (n == -1) {
                    n = string4.indexOf("*");
                }
                EExecResult eExecResult = null;
                if (n != -1) {
                    String string5 = string4.substring(0, n);
                    String string6 = string4.substring(n + 1, string4.length());
                    n = string2.lastIndexOf(".");
                    if (n != -1) {
                        String string7 = string2.substring(0, n);
                        String string8 = string3.equals("BPA") ? "/opt/hsc/bin/hscdc " + Crypt.encrypt("/bin/rpm") + " -e " + string7 : new String("/usr/sbin/invscout -RPM " + string7 + " -o \"'-e'\" -m " + string5 + " -s " + string6 + " -p " + this.parsePartitionID(string3));
                        String string9 = null;
                        try {
                            eExecResult = EExec.Exec((String)string8);
                            if (eExecResult.rc != 0) {
                                if (2 <= Trace.LEVEL) {
                                    Trace.trace(TRACE_MASKF, "Inventory Scout command " + string8 + " returned a non-zero return code. rc = " + eExecResult.rc);
                                    Trace.trace(TRACE_MASKF, "stderr is <" + eExecResult.stderr + ">");
                                }
                                string9 = eExecResult.stderr;
                            } else if (2 <= Trace.LEVEL) {
                                Trace.trace(TRACE_MASKF, "Inventory Scout command '" + string8 + "' succeeded");
                            }
                        }
                        catch (Exception exception) {
                            eExecResult.rc = 127;
                            Object[] objectArray = new Object[3];
                            objectArray[1] = Integer.toString(eExecResult.rc);
                            objectArray[0] = string8;
                            objectArray[2] = string9;
                            if (2 <= Trace.LEVEL) {
                                Trace.trace(TRACE_MASKF, "Throwing invcsout exception " + objectArray[0]);
                            }
                            throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0041", objectArray));
                        }
                        if (eExecResult.rc != 0) {
                            Object[] objectArray = new Object[3];
                            objectArray[1] = Integer.toString(eExecResult.rc);
                            objectArray[0] = string8;
                            objectArray[2] = string9;
                            if (2 <= Trace.LEVEL) {
                                Trace.trace(TRACE_MASKF, "Throwing invcsout exception " + objectArray[0]);
                            }
                            throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0041", objectArray));
                        }
                        break block21;
                    }
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "-- input parameter error, malformed rpmFile is: <" + string2 + ">");
                    }
                    Object[] objectArray = new Object[]{string2};
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "Throwing rpmfile exception " + objectArray[0]);
                    }
                    throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0046", objectArray));
                }
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "-- input parameter error, malformed MTMS is: <" + string4 + ">");
                }
                Object[] objectArray = new Object[]{string4};
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Throwing rpmfile exception " + objectArray[0]);
                }
                throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0045", objectArray));
            }
            catch (Exception exception) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "-- Exception caught is: " + exception);
                }
                throw new UcodeSurveyException("0048");
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.RPMPackageErase()");
        }
    }

    public String RPMPackageQuery(String string, String string2, String string3, String string4, String string5) throws UcodeSurveyException {
        String string6;
        block25: {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.RPMPackageQuery()");
            }
            string6 = null;
            EExecResult eExecResult = null;
            String string7 = " ";
            try {
                int n;
                String string8 = "/var/adm/invscout/microcode/" + string2;
                File file = new File(string8);
                if (!file.exists() || !file.isFile()) {
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "Downloading/Copying file " + string8);
                    }
                    if (this.getIOSurveyData().getReposLevel().getReposType() == 1) {
                        this.getFileFromCDROM(string5 + string2, "/var/adm/invscout/microcode/");
                    } else if (this.getIOSurveyData().getReposLevel().getReposType() == 4) {
                        this.getFileFromFtpSite(string, string5 + string2, string3, string4, "/var/adm/invscout/microcode/");
                    } else if (this.getIOSurveyData().getReposLevel().getReposType() == 0) {
                        this.getFileFromHttpSite(string2, "/var/adm/invscout/microcode/");
                    } else if (1 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKT, "ERROR - No valid repository location found!");
                    }
                }
                if ((n = string2.lastIndexOf(".")) > 0) {
                    String string9 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("/bin/rpm") + " -qpi " + string8;
                    try {
                        eExecResult = EExec.Exec((String)string9);
                        if (eExecResult.rc != 0) {
                            if (2 <= Trace.LEVEL) {
                                Trace.trace(TRACE_MASKF, "Command " + string9 + " returned a non-zero return code. rc = " + eExecResult.rc);
                                Trace.trace(TRACE_MASKF, "stderr is <" + eExecResult.stderr + ">");
                            }
                            string7 = eExecResult.stderr;
                        } else {
                            if (2 <= Trace.LEVEL) {
                                Trace.trace(TRACE_MASKF, "Command '" + string9 + "' succeeded");
                            }
                            string6 = eExecResult.stdout.trim();
                            if (2 <= Trace.LEVEL) {
                                Trace.trace(TRACE_MASKF, "execResult.stdout is <" + string6 + ">");
                            }
                        }
                        break block25;
                    }
                    catch (Exception exception) {
                        eExecResult.rc = 127;
                        Object[] objectArray = new Object[3];
                        objectArray[1] = Integer.toString(eExecResult.rc);
                        objectArray[0] = string9;
                        objectArray[2] = string7;
                        if (2 <= Trace.LEVEL) {
                            Trace.trace(TRACE_MASKF, "Throwing invcsout exception " + objectArray[0]);
                        }
                        throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0041", objectArray));
                    }
                }
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "-- input parameter error, malformed rpmFile is: <" + string2 + ">");
                }
                Object[] objectArray = new Object[]{string2};
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Throwing rpmfile exception " + objectArray[0]);
                }
                throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0046", objectArray));
            }
            catch (Exception exception) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "-- Exception caught is: " + exception);
                }
                throw new UcodeSurveyException("0050");
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.RPMPackageQuery()");
        }
        return string6;
    }

    public void ucodeInstall(String string, String string2, String string3, String string4) throws UcodeSurveyException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.doUcodeUpdate()");
        }
        String string5 = string;
        boolean bl = false;
        int n = string5.indexOf("_");
        if (n == -1) {
            n = string5.indexOf("*");
        }
        if (n != -1) {
            String string6 = string5.substring(0, n);
            String string7 = string5.substring(n + 1, string5.length());
            String string8 = string3 == null || string3.length() == 0 ? " " : " -f " + string3;
            String string9 = "";
            if (string4.equals("BPA")) {
                bl = true;
                string9 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("/opt/hsc/bin/frucode") + " installframe " + string3 + " -m " + string6 + string7;
            } else {
                bl = false;
                string9 = "/usr/sbin/invscout -FWM " + string2 + string8 + " -m " + string6 + " -s " + string7 + " -p " + this.parsePartitionID(string4);
            }
            EExecResult eExecResult = null;
            String string10 = " ";
            try {
                eExecResult = EExec.Exec((String)string9);
                if (bl) {
                    if (eExecResult.rc != 0) {
                        if (2 <= Trace.LEVEL) {
                            Trace.trace(TRACE_MASKF, "frucode command " + string9 + " returned a non-zero return code. rc = " + eExecResult.rc);
                            Trace.trace(TRACE_MASKF, "stderr is <" + eExecResult.stderr + ">");
                        }
                        string10 = eExecResult.stderr;
                    } else if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "frucode command '" + string9 + "' succeeded with a return code of " + eExecResult.rc);
                    }
                } else if (eExecResult.rc > 7) {
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "Inventory Scout command " + string9 + " returned a non-zero return code. rc = " + eExecResult.rc);
                        Trace.trace(TRACE_MASKF, "stderr is <" + eExecResult.stderr + ">");
                    }
                    string10 = eExecResult.stderr;
                } else if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Inventory Scout command '" + string9 + "' succeeded with a return code of " + eExecResult.rc);
                }
            }
            catch (Exception exception) {
                eExecResult.rc = 127;
                Object[] objectArray = new Object[3];
                objectArray[1] = Integer.toString(eExecResult.rc);
                objectArray[0] = string9;
                objectArray[2] = string10;
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Throwing invcsout exception " + objectArray[0]);
                }
                throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0041", objectArray));
            }
            if (eExecResult.rc > 7) {
                Object[] objectArray = new Object[3];
                objectArray[1] = Integer.toString(eExecResult.rc);
                objectArray[0] = string9;
                objectArray[2] = string10;
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Throwing invcsout exception " + objectArray[0]);
                }
                throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0041", objectArray));
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.doUcodeUpdate()");
        }
    }

    public Vector findUcodeResources() throws UcodeSurveyException {
        Object object;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.findUcodeResources()");
        }
        Vector vector = null;
        Vector vector2 = this.findAllCECs();
        if (vector2 != null && vector2.size() > 0) {
            vector = new Vector();
            object = vector2.elements();
            while (object.hasMoreElements()) {
                vector.addElement(object.nextElement());
            }
        }
        if ((object = this.findAllFrames()) != null && ((Vector)object).size() > 0) {
            if (vector == null) {
                vector = new Vector();
            }
            Enumeration enumeration = ((Vector)object).elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.findUcodeResources()");
        }
        return vector;
    }

    public Vector findAllCECs() {
        Vector vector;
        block14: {
            vector = null;
            Vector vector2 = null;
            Vector<String> vector3 = null;
            CECInfo cECInfo = null;
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.findAllCECs()");
            }
            try {
                Enumeration enumeration;
                vector2 = CIMUtils.getCECsInfo();
                if (2 <= Trace.LEVEL) {
                    if (vector2 != null && vector2.size() > 0) {
                        Trace.trace(TRACE_MASKF, "tempVector size is " + vector2.size());
                    } else {
                        Trace.trace(TRACE_MASKF, "getCECsInfo() returned a vector of size 0, or vector is null");
                    }
                }
                if (vector2 != null && vector2.size() > 0) {
                    vector = new Vector();
                    enumeration = vector2.elements();
                    while (enumeration.hasMoreElements()) {
                        cECInfo = (CECInfo)enumeration.nextElement();
                        if (2 <= Trace.LEVEL) {
                            Trace.trace(TRACE_MASKF, "model type is " + cECInfo.getCECModelType());
                            Trace.trace(TRACE_MASKF, "serial number is " + cECInfo.getCECSerialNumber());
                            Trace.trace(TRACE_MASKF, "machine name is " + cECInfo.getCECMachineName());
                        }
                        vector3 = new Vector<String>();
                        vector3.addElement(ResourceItem.resource_cec);
                        vector3.addElement(cECInfo.getCECModelType());
                        vector3.addElement(cECInfo.getCECSerialNumber());
                        vector3.addElement(cECInfo.getCECMachineName());
                        vector.addElement(vector3);
                    }
                }
                if (3 <= Trace.LEVEL) {
                    if (vector != null) {
                        Trace.trace(TRACE_MASKD, "getCECsInfo() found the following CECs:");
                        enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            Trace.trace(TRACE_MASKD, "CEC found of " + (String)enumeration.nextElement());
                        }
                    } else {
                        Trace.trace(TRACE_MASKD, "getCECsInfo returned null");
                    }
                }
            }
            catch (Throwable throwable) {
                if (1 > Trace.LEVEL) break block14;
                Trace.trace(TRACE_MASKF, "-- UcodeSurveyDownload.findAllCECs() exception is " + throwable);
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.findAllCECs()");
        }
        return vector;
    }

    public Vector findAllFrames() {
        Vector vector;
        block16: {
            EExecResult eExecResult = null;
            vector = null;
            Vector<String> vector2 = null;
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.findAllFrames()");
            }
            try {
                String string = "/opt/hsc/bin/hscdc " + Crypt.encrypt("/opt/hsc/bin/frucode") + " listframes";
                if (Trace.LEVEL >= 3) {
                    Trace.trace(TRACE_MASKD, "About to issue command: <" + string + ">");
                }
                eExecResult = EExec.Exec((String)string);
                if (eExecResult.rc != 0) {
                    if (Trace.LEVEL >= 2) {
                        Trace.trace(TRACE_MASKF, "Command " + string + " failed with a rc of " + eExecResult.rc + ".");
                        Trace.trace(TRACE_MASKF, "stderr is <" + eExecResult.stderr + ">");
                    }
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "Throwing exception " + eExecResult.rc);
                    }
                } else {
                    if (Trace.LEVEL >= 2) {
                        Trace.trace(TRACE_MASKF, "Command <" + string + "> completed with no errors.");
                        Trace.trace(TRACE_MASKF, "output data is <" + eExecResult.stdout + ">");
                    }
                    BufferedReader bufferedReader = new BufferedReader(new StringReader(eExecResult.stdout));
                    vector = new Vector();
                    String string2 = null;
                    string2 = bufferedReader.readLine().trim();
                    if (string2.length() != 0) {
                        while ((string2 = bufferedReader.readLine().trim()) != null) {
                            if (2 <= Trace.LEVEL) {
                                Trace.trace(TRACE_MASKF, "stdout line is: " + string2);
                            }
                            StringTokenizer stringTokenizer = new StringTokenizer(string2);
                            String string3 = stringTokenizer.nextToken();
                            String string4 = string3.substring(0, 8);
                            String string5 = string3.substring(8);
                            String string6 = stringTokenizer.nextToken();
                            vector2 = new Vector<String>();
                            if (2 <= Trace.LEVEL) {
                                Trace.trace(TRACE_MASKF, "mtm is <" + string4 + ">, s/n is <" + string5 + ">, Frame ID is is <" + string6 + ">");
                            }
                            vector2.addElement(ResourceItem.resource_bpa);
                            vector2.addElement(string4);
                            vector2.addElement(string5);
                            vector2.addElement(string6);
                            vector.addElement(vector2);
                        }
                    } else if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "No data returned from BPA query.");
                    }
                }
            }
            catch (Exception exception) {
                if (1 > Trace.LEVEL) break block16;
                Trace.trace(TRACE_MASKF, "-- UcodeSurveyDownload.findAllFrames() exception is " + exception);
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.findAllFrames()");
        }
        return vector;
    }

    private String getLogFile(String string) {
        String string2;
        block4: {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.getLogFile()");
            }
            string2 = null;
            try {
                File file = new File(string);
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[(int)file.length()];
                fileInputStream.read(byArray);
                fileInputStream.close();
                string2 = new String(byArray);
            }
            catch (Throwable throwable) {
                if (2 > Trace.LEVEL) break block4;
                Trace.trace(TRACE_MASKF, "The requested log file: " + string + " could not be read.");
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.getLogFile()");
        }
        return string2;
    }

    public Properties initUcodeProperties() throws UcodeSurveyException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->UcodeSurveyUtils.initUcodeProperties()");
        }
        String string = "";
        Properties properties = null;
        properties = UcodeSurveyProperties.initialize("/var/adm/invscout/ucodesurvey.properties", null);
        string = UcodeSurveyProperties.getProperty("weburl");
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "weburl is: " + string);
            Trace.trace(TRACE_MASKT, "<-UcodeSurveyUtils.initUcodeProperties()");
        }
        return properties;
    }

    public void saveUcodeProperties(Properties properties) throws UcodeSurveyException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->UcodeSurveyUtils.saveUcodeProperties()");
        }
        UcodeSurveyProperties.save(properties);
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-UcodeSurveyUtils.saveUcodeProperties()");
        }
    }
}

